/******************************************************************************/
#include "stdafx.h"
/******************************************************************************
 
   In this tutorial is presented how to achieve high ambient lighting value with satisfactionary looks

/******************************************************************************/
struct AmbientControls
{
   Window    win;
   Text     tmode,tsoft,tjitter,thalf_res,tpower,tcontrast,trange,tscale,tbias;
   ComboBox  mode, soft;
   CheckBox  jitter,half_res;
   Slider    power,contrast,range,scale,bias;

   void create()
   {
      static Char *modes[]=
      {
         "off",
         "low",
         "high #1",
         "high #2",
         "high #3",
         "high #4",
      };
      static Char *softing[]=
      {
         "0",
         "1",
         "2",
      };
      Flt y=0,h=0.062;
      Gui+= win     .create(Rect_RD(D.w(),-D.h(),0.9,0.67),"Ambient Parameters").hide(); y-=h;
      win+=tmode    .create(Vec2   (0.2,y),"Mode"           ); win+=mode    .create(Rect_C(0.2+win.crect.w()/2,y,0.25,0.05),modes  ,ELMS(modes  )).set(D.ambMode()); y-=h;
      win+=tsoft    .create(Vec2   (0.2,y),"Soft"           ); win+=soft    .create(Rect_C(0.2+win.crect.w()/2,y,0.25,0.05),softing,ELMS(softing)).set(D.ambSoft()); y-=h;
      win+=tjitter  .create(Vec2   (0.2,y),"Jitter"         ); win+=jitter  .create(Rect_C(0.2+win.crect.w()/2,y,0.05,0.05),D.ambJitter  ()    ); y-=h;
      win+=thalf_res.create(Vec2   (0.2,y),"Half Resolution"); win+=half_res.create(Rect_C(0.2+win.crect.w()/2,y,0.05,0.05),D.ambHalfRes ()    ); y-=h;
      win+=tpower   .create(Vec2   (0.2,y),"Power"          ); win+=power   .create(Rect_C(0.2+win.crect.w()/2,y,0.25,0.05),D.ambPower   ()    ); y-=h;
      win+=tcontrast.create(Vec2   (0.2,y),"Contrast"       ); win+=contrast.create(Rect_C(0.2+win.crect.w()/2,y,0.25,0.05),D.ambContrast()/4  ); y-=h;
      win+=trange   .create(Vec2   (0.2,y),"Range"          ); win+=range   .create(Rect_C(0.2+win.crect.w()/2,y,0.25,0.05),D.ambRange   ()/0.4); y-=h;
      win+=tscale   .create(Vec2   (0.2,y),"3D Scale"       ); win+=scale   .create(Rect_C(0.2+win.crect.w()/2,y,0.25,0.05),D.ambScale   ()/4  ); y-=h;
      win+=tbias    .create(Vec2   (0.2,y),"Bias"           ); win+=bias    .create(Rect_C(0.2+win.crect.w()/2,y,0.25,0.05),D.ambBias    ()    ); y-=h;
   }
}AC;
/******************************************************************************/
Mesh   mbackground,
       mball,
       mbox ;
Matrix matrix_ball[25],
       matrix_box [25];
/******************************************************************************/
void InitPre()
{
   App.name="Ambient Occlusion";
   App.flag=APP_FULL_TOGGLE;
   PakAdd("../data/engine.pak");

   D.full(true).ambMode(AMB_HIGH3).ambSoft(1).ambJitter(1).ambHalfRes(1).ambPower(0.8); // set initial ambient occlusion parameters

   Ms.hide(); // hide mouse
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=5;

   Material *brick=Materials("../data/mtrl/brick/0.mtrl"),
            *glass=Materials("../data/mtrl/glass/0.mtrl");

   mbackground.create(1).B(0).create( Box(3  ),VTX_TX0|VTX_NRM|VTX_TNG).reverse(); // create background box
   mbox       .create(1).B(0).create( Box(0.5),VTX_TX0|VTX_NRM|VTX_TNG);           // create box
   mball      .create(1).B(0).create(Ball(0.5),VTX_TX0|VTX_NRM|VTX_TNG);           // create ball

   mbackground.setMaterial(brick).setRender().setBox();
   mbox       .setMaterial(glass).setRender().setBox();
   mball      .setMaterial(glass).setRender().setBox();

   // setup random matrixes
   REPA(matrix_ball)matrix_ball[i].setRotateXY(RndF(PI2),RndF(PI2)).move(Rnd(mbackground.box));
   REPA(matrix_box )matrix_box [i].setRotateXY(RndF(PI2),RndF(PI2)).move(Rnd(mbackground.box));

   AC.create();

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   Gui.update();
   CamHandle(0.01,100,Ms.hidden ? CAMH_ZOOM|(Ms.b(1)?CAMH_MOVE:CAMH_ROT) : 0); // when mouse hidden operate the camera

   if(Kb.bp(KB_TAB))
   {
         Ms .toggle               (); // toggle mouse  visibility when tab pressed
      AC.win.visibleToggleActivate(); // toggle window visibility when tab pressed
   }

   // set Ambient Occlusion parameters
   D.ambMode    (AC.mode    ())
    .ambSoft    (AC.soft    ())
    .ambJitter  (AC.jitter  ())
    .ambHalfRes (AC.half_res())
    .ambPower   (AC.power   ())
    .ambContrast(AC.contrast()*4)
    .ambRange   (AC.range   ()*0.4)
    .ambScale   (AC.scale   ()*4)
    .ambBias    (AC.bias    ());

   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SOLID:
         mbackground.draw(MatrixIdentity);
         REPA(matrix_ball)mball.draw(matrix_ball[i]);
         REPA(matrix_box )mbox .draw(matrix_box [i]);
      break;
   }
}
void Draw()
{
   Renderer(Render);
   Gui.draw();
   if(Ms.hidden)D.text(0,0.9,S+"Press Tab to toggle parameters");
   else         D.text(0,0.9,S+"Fps: "+Tm.fps);
}
/******************************************************************************/
